//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

vec3 DrawShootingStar(vec3 clr,vec3 viewPos,float variation,float dither){
	#ifdef SHOOTING_STARS_AA
	#if AA>1
	dither=fract(16.*frameTimeCounter+dither);
	#endif
	#else
	dither=1.0;
	#endif

	float frameShootingStar = frameTimeCounter / SPEED_SHOOTING;
	float visibility=moonVisibility*(1.-rainStrength)*(1.-rainStrengthS);
    float sectime = mod(frameShootingStar,1.0);
    
    float lim1 = 59.0*variation;
    float lim2 = 69.0*variation;

    float time1 = mod(floor(frameShootingStar),lim1)/lim1;
    float time2 = mod(floor(frameShootingStar),lim2)/lim2;

    vec3 wpos=vec3(gbufferModelViewInverse*vec4(viewPos,1.));
    vec3 sstarpos1start = texture2D(noisetex,vec2(time1,time2)).rgb;
    sstarpos1start.xz = (sstarpos1start.xz * 2.0) - 1.0;
    vec3 sstarpos2start = texture2D(noisetex,vec2(1-time1,1-time2)).rgb;
    sstarpos2start.xz = (sstarpos2start.xz * 2.0) - 1.0;

	float isShooting = texture2D(noisetex,vec2 (time2,time1)).r;

    sstarpos1start = normalize(sstarpos1start);
    sstarpos2start = normalize(sstarpos2start);
    if(length(sstarpos1start-sstarpos2start) > 0.7 && visibility>0.0 && isShooting < SHOW_DELAY)
    {
		vec3 sstarpos1;
		vec3 sstarpos2;
		if(sectime < 0.5)
		{
			sstarpos1 = mix(sstarpos2start,sstarpos1start,sectime*2.0);
			sstarpos2 = sstarpos2start;
		}
		else
		{
			sstarpos1 = sstarpos1start;
			sstarpos2 = mix(sstarpos1start,sstarpos2start,(1.0-sectime)*2.0);
			
		}
			sstarpos1 = normalize(sstarpos1);
			sstarpos2 = normalize(sstarpos2);
			wpos = normalize(wpos);

		float l1=length(sstarpos1-wpos);
		float l2=length(sstarpos2-wpos);
		float l3=length(sstarpos1-sstarpos2);
		if (l3<STAR_THICKNESS)l3 = STAR_THICKNESS;
		float l4=length(((sstarpos1+sstarpos2)/2.0) - wpos);

		vec3 ss3 = cross(sstarpos1,sstarpos2);
		ss3 = normalize(ss3);
		float dist = dot(wpos,ss3);
		
		if (dist < 0 ) dist = -dist;
		if ((dist < STAR_THICKNESS && l3>l1  && l3>l2) || l1 < STAR_THICKNESS)
		{

			float t1 = 1.0-(dist / STAR_THICKNESS);
			float t2 = 1.0 -(l1 / l3);
			t2 = pow(t2,SHOOTING_STARS_FADE);
			float t = t1*t2*dither;
			float fade = clamp((1.0 - sectime), 0.0, 1.0);
			fade = clamp(pow(fade,15.0) * 600.0, 0.0, 1.0);
			clr = clamp(mix(clr,vec3 (SHOOTING_INTENSITY) * 20.0 ,t * fade), 0.0, 20.0);

		}
    }
    return clr;
}